<?php
/**
 * The template part for displaying grid post
 *
 * @package Advance Automobile
 * @subpackage advance-automobile
 * @since advance-automobile 1.0
 */
?>
<?php 
  $archive_year  = get_the_time('Y'); 
  $archive_month = get_the_time('m'); 
  $archive_day   = get_the_time('d'); 
?>
<div class="col-lg-4 col-md-4">
  <article class="page-box p-4 mb-4">
    <?php if( get_theme_mod( 'advance_automobile_show_featured_image_post',true) != '') { ?>
      <div class="box-img mb-3">
        <?php the_post_thumbnail(); ?>
      </div>
    <?php } ?>
    <div class="new-text">
      <?php if( get_theme_mod( 'advance_automobile_date_hide',true) != '' || get_theme_mod( 'advance_automobile_author_hide',true) != '' || get_theme_mod( 'advance_automobile_comment_hide',true) != '' || get_theme_mod( 'advance_automobile_time_hide',true) != '') { ?>
        <div class="metabox">
          <?php if( get_theme_mod( 'advance_automobile_date_hide',true) != '') { ?>
            <span class="entry-date me-3"><a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><?php echo esc_html( get_theme_mod('advance_automobile_metabox_separator_blog_post') ); ?>
          <?php } ?>
          <?php if( get_theme_mod( 'advance_automobile_author_hide',true) != '') { ?>
            <span class="entry-author me-3"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span><?php echo esc_html( get_theme_mod('advance_automobile_metabox_separator_blog_post') ); ?>
          <?php } ?>
          <?php if( get_theme_mod( 'advance_automobile_comment_hide',true) != '') { ?>
            <span class="entry-comments me-3"><?php comments_number( __('0 Comments','advance-automobile'), __('0 Comments','advance-automobile'), __('% Comments','advance-automobile') ); ?></span>
          <?php } ?>
          <?php if( get_theme_mod( 'advance_automobile_time_hide',false) != '') { ?>
            <span class="entry-time"><?php echo esc_html( get_the_time() ); ?></span>
          <?php }?>
        </div>
      <?php }?>
      <h2 class="text-uppercase"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
      <div class="entry-content"><p class="my-3"><?php $excerpt = get_the_excerpt(); echo esc_html( advance_automobile_string_limit_words( $excerpt, esc_attr(get_theme_mod('advance_automobile_excerpt_number','20')))); ?> <?php echo esc_html( get_theme_mod('advance_automobile_post_suffix_option','...') ); ?></p></div>
      <?php if( get_theme_mod('advance_automobile_button_text','READ MORE') != ''){ ?>
        <div class="read-more-btn mt-3">
          <a href="<?php the_permalink(); ?>" class="py-3 px-4"><?php echo esc_html(get_theme_mod('advance_automobile_button_text','READ MORE'));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('advance_automobile_button_text','READ MORE'));?></span></a>
        </div>
      <?php } ?>
    </div>
    <div class="clearfix"></div>
  </article>
</div>